#ifndef __OPD_JP2_H
#define __OPD_JP2_H

#include <stdlib.h>

#if defined WIN32 && defined _USRDLL
#define LIBJ2K_API __declspec(dllexport)
#else
#define LIBJ2K_API
#endif

#ifdef __cplusplus
extern "C" {
#endif


/* Version number of the Library */
#define OPD_JP2_MAJOR_VERSION	1
#define OPD_JP2_MINOR_VERSION	6
#define OPD_JP2_LIBRARY_VERSION	(OPD_JP2_MAJOR_VERSION << 8 | OPD_JP2_MINOR_VERSION)

#define OPD_ENCODE_LOSSLESS		0
#define OPD_ENCODE_LOSSY		1

#define OPD_NO_ERROR							0
#define OPD_ERROR_INVALID_PARAMETER				-1
#define OPD_ERROR_NOT_IMPLEMENTED				-2
#define OPD_ERROR_INCOMPLETE_DATA				-3
#define OPD_ERROR_HEADER_CORRUPT				-4
#define OPD_ERROR_INVALID_QUALITY_LAYERS		-10
#define OPD_ERROR_DESTINATION_BUFFER_TOO_SMALL	-11
#define OPD_ERROR_INVALID_LICENSE				-12
#define OPD_ERROR_UNREGISTERED					-13
#define OPD_ERROR_ALREADY_REGISTERED			-14
#define OPD_ERROR_DEMO_LICENSE					-15
#define OPD_ERROR_DEMO_EXPIRED					-16
#define OPD_ERROR_INVALID_LIBRARY_VERSION		-17
#define OPD_ERROR_OUT_OF_MEMORY					-18

typedef struct {
	/* Simple structure for an interleaved image 
	 * introduced with version 1.5 of the library */
	unsigned char	*pucData;
	unsigned int	uiDataOffset;
	unsigned int	uiWidth;
	unsigned int	uiHeight;
	unsigned int	uiChannels;
	int				iDx;
	int				iDy;
	int				iDc;
	int				iPrecision;
} opd_image_t;

typedef struct opd_jp2Decoder_t {
	unsigned char	**pucTileData;
	unsigned int	*iTileLen;
} opd_jp2Decoder_t;

typedef struct opd_jp2_param_t {
	int		filesize;
	int		lossless;
	int		resolution_levels;
	int		quality_layers;
	int		bCodestream;
	int		iLibraryVersion;
} opd_jp2_param;

/* New functions */
LIBJ2K_API int opd_jp2_compress(opd_image_t *image, unsigned char* dest, int dest_size, opd_jp2_param *param);
LIBJ2K_API int opd_jp2_decompress(unsigned char* src, int src_size, opd_image_t **image);
LIBJ2K_API int opd_jp2_decompress_scaled(unsigned char* src, int src_size, opd_image_t *image, int iDownscale, int iQuality);
LIBJ2K_API int opd_jp2_compress_licensed(opd_image_t *image, unsigned char* dest, int dest_size, opd_jp2_param *param, unsigned char *licenseString);
LIBJ2K_API int opd_jp2_decompress_licensed(unsigned char* src, int src_size, opd_image_t **image, unsigned char *licenseString);

LIBJ2K_API void *opd_jp2_alloc(size_t size);
LIBJ2K_API void opd_jp2_free(void *ptr);
LIBJ2K_API void opd_jp2_freeImage(opd_image_t *image);

LIBJ2K_API int opd_register(unsigned char *szLicense);
LIBJ2K_API int opd_checkRegistration();

#ifdef __cplusplus
};
#endif

#endif /* __OPD_JP2_H */
